% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/durPlot.R
\name{durPlot}
\alias{durPlot}
\title{Graphs and Summary for Date Durations}
\usage{
durPlot(df, start, end, group=NA, timeunit="days", plot_type="all",
       facet=FALSE, facet.nrow=NULL, theme=NULL, other=NULL,
       fill_color="black", line_color="black", groupcolor=TRUE,
       point_size=2, alpha=NA, binwidth=0.5, show_legend=TRUE,
       title=FALSE, title_boxplot="Boxplot", title_histogram="Histogram",
       title_density="Density Plot", title_scatter="Scatter Plot", title_line="Line Plot")
}
\arguments{
\item{df}{Data frame containing start dates, end dates and groups.}

\item{start}{Column in df for start dates.}

\item{end}{Column in df for end dates.}

\item{group}{Column in df for groups. Default is NA.}

\item{timeunit}{Unit of time to be used in plots.
\code{"day(s)","week(s)","month(s)","quarter(s)","semiannual", "halfyear", "half-year", "semi-annual", "year(s)"}. Default is \code{"days"}.}

\item{plot_type}{One of \code{"all", "boxplot", "histogram", "density", "scatter", "line"}. Default is \code{"all"}.}

\item{facet}{If TRUE, wraps plots in group facets}

\item{facet.nrow}{Number of rows for facet wrap}

\item{theme}{Add theme elements if needed.}

\item{other}{Add other elements if needed.}

\item{fill_color}{Fill color}

\item{line_color}{Line color}

\item{groupcolor}{If FALSE, fill_color and line_color used for all groups. Default is TRUE.}

\item{point_size}{Point size for scatterplot}

\item{alpha}{Color transparency [0,1]}

\item{binwidth}{Binwidth for histogram; default 0.5.}

\item{show_legend}{Default is TRUE}

\item{title}{If TRUE, puts main titles for each plot}

\item{title_boxplot}{Title for boxplot title}

\item{title_histogram}{Title for histogram}

\item{title_density}{Title for density plot}

\item{title_scatter}{Title for scatter plot}

\item{title_line}{Title for line plot}
}
\description{
Plots boxplot, histogram, density plot, scatter plot, line plot and prints summary statistics for date duration data.
}
\details{
The function also returns summary statistics for the specified date duration.
}
\examples{
durPlot(life_exp, start="Birth", end="Death", group="Country",
timeunit="years", facet=TRUE, binwidth=3, alpha=0.7, title=TRUE)
durPlot(life_exp, start="Birth", end="Death", group="Country",
timeunit="years",alpha=0.5, title=TRUE)
}
\author{
Dahee Lee
}
\seealso{
\code{\link{timelineS}}, \code{\link{timelineG}}, \code{\link{durSummary}}, \code{\link{durCalc}}
}

