% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.timedeppar.R
\name{plot.timedeppar}
\alias{plot.timedeppar}
\title{Plot results of time-dependent parameter estimation}
\usage{
\method{plot}{timedeppar}(
  x,
  type = c("traces", "marginals", "summary", "pairs", "time-series", "accept"),
  chains.at = numeric(0),
  labels = NA,
  units = NA,
  prob.band = 0.9,
  max.diag.plots = 100,
  xlim.ts = numeric(0),
  n.burnin = 0,
  nrow = 4,
  nrow.constpar = NA,
  nrow.timedeppar = NA,
  nrow.diagnostics = NA,
  ...
)
}
\arguments{
\item{x}{results from the function \code{\link{infer.timedeppar}} of class \code{timedeppar} or
list of such results for comparing multiple chains (in the latter case you have to call
explicitly \code{plot.timedeppar} rather than being able to do the generic call \code{plot}
as the list of results is not an object of class \code{timedeppar}).}

\item{type}{vector of plot types:\cr
\code{"traces"} or \code{"marginals"}: traces and 1d marginals of Markov chains of 
                  constant parameters, of time-dependent parameters at certain time points
                  (see argument \code{chains.at}), chains of log posterior and
                  log observational likelihood values. 
                  For selected outputs only, specify
                  \code{traces.constpar}, \code{traces.timedeppar}, 
                  \code{traces.logposterior}.\cr
\code{"summary"}: print summary of acceptance rates and maximum log posterior and 
                  log likelihood values.\cr
\code{"pairs"}: scatterplot matrix of posterior sample of constant parameters.\cr
\code{"time-series"}: uncertainty range and median time series of
                      time-dependent parameters.\cr
\code{"accept"}: time series of apparent acceptance frequencies (at the level of thinning).\cr
\code{"realizations"}: realizations of time-dependent parameters to check for burnin..\cr
\code{"diagnostics"}: plot diagnostics for inference of time-dependent parameters
                      (note that the plot file could become very large 
                      to follow the inference steps).}

\item{chains.at}{vector of time points at which chains and marginals of time-dependent parameters 
should be plotted if \code{"traces"} or \code{"marginals"} is contained in the vector argument
\code{type} (default: none [numeric(0)]).}

\item{labels}{optional named vector of expressions to label variables in the plots (names of the expression
have to correspond to the variable names as used by the program, expressions can have special
symbols, e.g. \code{expression(a=alpha,b=beta,c1=gamma[1])}).}

\item{units}{optional named vector of expressions to add units to variables in the plots (names of the expression
have to correspond to the variable names as used by the program, expressions can have special
symbols, e.g. \code{expression(a=m^3/s,b=h^-1,c1=m)}).}

\item{prob.band}{probability defining the width of the uncertainty bands plotted for output variables
(default value: 0.9)}

\item{max.diag.plots}{maximum number of diagnostic plots of inference steps}

\item{xlim.ts}{optional range of time values for time-series plot}

\item{n.burnin}{number of Markov chain points to omit for density and pairs plots
(number of omitted points is max(control$n.adapt,n.burnin)).}

\item{nrow}{number of plot rows per page (except for pairs plot).}

\item{nrow.constpar}{number of plot rows per page for traces and marginals (default is nrow).}

\item{nrow.timedeppar}{number of plot rows per page for time-dependent parameters (default is nrow).}

\item{nrow.diagnostics}{number of plot rows per page for diagnostics plots (default is nrow).}

\item{...}{additional arguments passed to the plotting function.}
}
\description{
This function plot Markov chains and marginal densities of constant parameters, distributions of
time dependent parameters, and Markov chains and marginal densities of time-dependent parameters at
selected points in time.
}
