% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time-zones.R
\name{time-zones}
\alias{time-zones}
\alias{time_at_tz}
\alias{time-zones}
\alias{time_force_tz}
\alias{time-zones}
\alias{time_clock_at_tz}
\title{Time-zone manipulation}
\usage{
time_at_tz(time, tz = "UTC")

time_force_tz(time, tz = "UTC", tzout = tz[[1]], roll_dst = "boundary")

time_clock_at_tz(time, tz = NULL, units = "secs")
}
\arguments{
\item{time}{a date-time object (POSIXct, POSIXlt, Date) or a list of
date-time objects. When a list, all contained elements are updated the new
list is returned.}

\item{tz}{a character string containing the time zone to convert to. R must
recognize the name contained in the string as a time zone on your
system. For \code{time_force_tz} and \code{time_clock_at_tzs}, \code{tz} can be a vector
of heterogeneous time-zones, in which case \code{time} and \code{tz} arguments are
paired. If \code{time} and \code{tz} lengths differ, the smaller one is recycled
according with usual R conventions.}

\item{tzout}{timezone of the output date-time vector. Meaningfull only when
\code{tz} argument is a vector of heterogenuous time-zones. This argument is
necessary because R date-time vectors cannot hold elements with different
time-zones.}

\item{roll_dst}{same as in \code{time_add} which see.}

\item{units}{passed directly to \code{\link[=as.difftime]{as.difftime()}}.}
}
\value{
a POSIXct object with the updated time zone
}
\description{
\code{time_at_tz} returns a date-time as it would appear in a
different time zone. The actual moment of time measured does not change,
just the time zone it is measured in. \code{time_at_tz} defaults to the
Universal Coordinated time zone (UTC) when an unrecognized time zone is
supplied.

\code{time_force_tz} returns the date-time that has the same clock
time as input time, but in the new time zone. Although the new date-time
has the same clock time (e.g. the same values in the seconds, minutes,
hours, etc.) it is a different moment of time than the input
date-time. Computation is vectorized over both \code{time} and \code{tz} arguments.

\code{time_clock_at_tz} retrieves day clock time in specified time
zones. Computation is vectorized over both \code{dt} and \code{tz} arguments, \code{tz}
defaults to the timezone of \code{time}.
}
\examples{

x <- as.POSIXct("2009-08-07 00:00:00", tz = "America/New_York")
time_at_tz(x, "UTC")
time_force_tz(x, "UTC")
time_force_tz(x, "Europe/Amsterdam")

## DST skip:

y <- as.POSIXct("2010-03-14 02:05:05", tz = "UTC")
time_force_tz(y, "America/New_York", roll = "boundary")
time_force_tz(y, "America/New_York", roll = "first")
time_force_tz(y, "America/New_York", roll = "last")
time_force_tz(y, "America/New_York", roll = "NA")

## Heterogeneous time-zones:

x <- as.POSIXct(c("2009-08-07 00:00:01", "2009-08-07 01:02:03"), tz = "UTC")
time_force_tz(x, tz = c("America/New_York", "Europe/Amsterdam"))
time_force_tz(x, tz = c("America/New_York", "Europe/Amsterdam"), tzout = "America/New_York")

x <- as.POSIXct("2009-08-07 00:00:01", tz = "UTC")
time_force_tz(x, tz = c("America/New_York", "Europe/Amsterdam"))

## Local clock:

x <- as.POSIXct(c("2009-08-07 01:02:03", "2009-08-07 10:20:30"), tz = "UTC")
time_clock_at_tz(x, units = "secs")
time_clock_at_tz(x, units = "hours")
time_clock_at_tz(x, "Europe/Amsterdam")

x <- as.POSIXct("2009-08-07 01:02:03", tz = "UTC")
time_clock_at_tz(x, tz = c("America/New_York", "Europe/Amsterdam", "Asia/Shanghai"), unit = "hours")
}
