% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/states.R
\name{states}
\alias{states}
\title{Download shapefile for all states into R}
\usage{
states(cb = FALSE, resolution = "500k", year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
states file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{resolution}{The resolution of the cartographic boundary file (if cb == TRUE).
Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{year}{the data year; defaults to 2020}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
States and Equivalent Entities are the primary governmental divisions of the
United States.  In addition to the 50 states, the Census Bureau treats the
District of Columbia, Puerto Rico, American Samoa, the Commonwealth of the
Northern Mariana Islands, Guam, and the U.S. Virgin Islands as the statistical
equivalents of states for the purpose of data presentation.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
}
}

\examples{
\dontrun{
library(tigris)
library(leaflet)

states <- states(cb = TRUE)

leaflet(states) \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  addPolygons(fillColor = "white",
              color = "black",
              weight = 0.5) \%>\%
  setView(-98.5795, 39.8282, zoom=3)
}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch4GARM.pdf}

Other general area functions: 
\code{\link{block_groups}()},
\code{\link{blocks}()},
\code{\link{counties}()},
\code{\link{county_subdivisions}()},
\code{\link{places}()},
\code{\link{pumas}()},
\code{\link{school_districts}()},
\code{\link{tracts}()},
\code{\link{zctas}()}
}
\concept{general area functions}
