% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration_units.R
\name{county_subdivisions}
\alias{county_subdivisions}
\title{Download a county subdivision shapefile into R}
\usage{
county_subdivisions(state, county = NULL, cb = FALSE, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state you want. Can also
be state name or state abbreviation.}

\item{county}{The three-digit FIPS code (string) of the county you'd like to
subset for, or a vector of FIPS codes if you desire multiple counties.
Can also be a county name or vector of names.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data year; defaults to 2020}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
From the US Census Bureau (see link for source, and more information): "All counties and
statistically equivalent entities consist of one or more geographic units that the Bureau
of the Census recognizes as county subdivisions. The two major types of county subdivisions
 are minor civil divisions(MCDs) and census county divisions (CCDs).
 A State has either MCDs or their statistical equivalents, or CCDs; it cannot
 contain both."
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
}
}

\examples{
\dontrun{
library(tigris)

or <- county_subdivisions('Oregon', c('Linn', 'Benton'))

plot(or$geometry)

}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch8GARM.pdf}

Other general area functions: 
\code{\link{block_groups}()},
\code{\link{blocks}()},
\code{\link{counties}()},
\code{\link{places}()},
\code{\link{pumas}()},
\code{\link{school_districts}()},
\code{\link{states}()},
\code{\link{tracts}()},
\code{\link{zctas}()}
}
\concept{general area functions}
