% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration_units.R
\name{county_subdivisions}
\alias{county_subdivisions}
\title{Download a county subdivision shapefile into R}
\usage{
county_subdivisions(state, county = NULL, cb = FALSE, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state you want. Can also
be state name or state abbreviation.}

\item{county}{The three-digit FIPS code (string) of the county you'd like to
subset for, or a vector of FIPS codes if you desire multiple counties.
Can also be a county name or vector of names.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data year (defaults to 2018).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sp"} (the default) or \code{"sf"} to
request sp or sf class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
From the US Census Bureau (see link for source, and more information): "All counties and
statistically equivalent entities consist of one or more geographic units that the Bureau
of the Census recognizes as county subdivisions. The two major types of county subdivisions
 are minor civil divisions(MCDs) and census county divisions (CCDs).
 A State has either MCDs or their statistical equivalents, or CCDs; it cannot
 contain both."
}
\examples{
\dontrun{
library(tigris)

or <- county_subdivisions('Oregon', c('Linn', 'Benton'))

plot(or)

}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch8GARM.pdf}

Other general area functions: 
\code{\link{block_groups}()},
\code{\link{blocks}()},
\code{\link{counties}()},
\code{\link{places}()},
\code{\link{pumas}()},
\code{\link{school_districts}()},
\code{\link{states}()},
\code{\link{tracts}()},
\code{\link{zctas}()}
}
\concept{general area functions}
