% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transportation.R
\name{roads}
\alias{roads}
\title{Download a roads shapefile into R}
\usage{
roads(state, county, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code of the state of the county you'd like
to download the roads for. Can also be state name or abbreviation
(case-insensitive).}

\item{county}{The three-digit FIPS code of the county you'd like the roads for.
Can also be a county name.}

\item{year}{the data year (defaults to 2016).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
From the Census Bureau: "The content of the all roads shapefile includes
primary roads, secondary roads, local neighborhood roads,
rural roads, city streets, vehicular trails (4WD), ramps, service drives,
walkways, stairways, alleys, and private roads."
}
\examples{
\dontrun{
library(tigris)
library(ggplot2)
library(ggthemes)
library(rgeos)
library(sp)

roads <- roads("Maine", "031")

# for ggplot, we need to simplify the lines otherwise it'll take
# forever to plot. however, gSimplify whacks the SpatialLinesDataFrame
# so we need to re-bind the data from the original object to it so
# we can use "fortify"

roads_simp <- gSimplify(roads, tol=1/200, topologyPreserve=TRUE)
roads_simp <- SpatialLinesDataFrame(roads_simp, roads@data)

roads_map <- fortify(roads_simp) # this takes a bit

gg <- ggplot()
gg <- gg + geom_map(data=roads_map, map=roads_map,
                    aes(x=long, y=lat, map_id=id),
                    color="black", fill="white", size=0.25)
gg <- gg + coord_map()
gg <- gg + theme_map()
gg
}
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2015/TGRSHP2015_TechDoc.pdf}

Other transportation functions: \code{\link{primary_roads}},
  \code{\link{primary_secondary_roads}},
  \code{\link{rails}}
}
