% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{insertSupplementaryData}
\alias{insertSupplementaryData}
\title{Insert supplementary data}
\usage{
insertSupplementaryData(db, name, suppData, regulatorName = NA, source = "",
  platform = "", description = "")
}
\arguments{
\item{db}{Database object created by \code{\link{initializeDb}}}

\item{name}{Name of the supplementary data}

\item{suppData}{A vector of supplementary data of elements identified by names}

\item{regulatorName}{Regulator name the data links to (optional)}

\item{source}{Optional annotation: source}

\item{platform}{Optional annotation: platform}

\item{description}{Optional annotation: description}
}
\value{
An updated database object db
}
\description{
Insert supplementary data
}
\examples{
  db <- initializeDb("", "My Dataset")
  suppdata <- c(1, 2, 3)
  names(suppdata) <- c("A", "B", "C")
  db <- insertSupplementaryData(db, "supptest", suppdata)
  boolsupp <- c(TRUE, TRUE, FALSE)
  names(boolsupp) <- names(suppdata)
  db <- insertSupplementaryData(db, "supptest_bool", boolsupp)
  closeDb(db)
}

