% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_all_with_p.R
\name{tw_get_all_with_p}
\alias{tw_get_all_with_p}
\title{Get all items that have a given property (irrespective of the value)}
\usage{
tw_get_all_with_p(
  p,
  fields = c("item", "itemLabel", "itemDescription"),
  language = tidywikidatar::tw_get_language(),
  method = "SPARQL",
  wait = 0.1,
  limit = Inf,
  return_as_tw_search = TRUE
)
}
\arguments{
\item{p}{A character vector, a property. Must always start with the capital letter "P", e.g. "P31" for "instance of".}

\item{fields}{A character vector of Wikidata fields. Ignored if \code{return_as_tw_search} is set to TRUE (as per default). Defaults to \verb{("item", "itemLabel", "itemDescription")}}

\item{language}{Defaults to language set with \code{tw_set_language()}; if not set, "en". If more than one, can be set in order of preference, e.g. \code{c("it", "fr", "en")}. Use "all_available" to keep all languages. For available language values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{method}{Defaults to "SPARQL". The only accepted alternative value is "JSON", to use instead json-based API.}

\item{wait}{Defaults to 0.1. Used only in method is set to "JSON".}

\item{limit}{Defaults to \code{Inf}. Set to smaller values for testing and cache locally when possible to reduce load on servers.}

\item{return_as_tw_search}{Logical, defaults to TRUE. If TRUE, returns a data frame with three columns (id, label, and description) that can be piped to other \code{tw_} functions. If FALSE, a data frame with as many columns as fields.}
}
\value{
A data frame with three columns is method is set to "SPARQL", or as many columns as fields if more are given and \code{return_as_tw_search} is set to FALSE. A single column with Wikidata identifier if method is set to "JSON".
}
\description{
This function does not cache results.
}
\examples{
if (interactive()) {
  # get all Wikidata items with an ICAO airport code ("P239")
  tw_get_all_with_p(p = "P239", limit = 10)
}
}
