% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_connect_to_cache.R
\name{tw_connect_to_cache}
\alias{tw_connect_to_cache}
\title{Return a connection to be used for caching}
\usage{
tw_connect_to_cache(
  connection = NULL,
  RSQLite = NULL,
  language = NULL,
  cache = NULL
)
}
\arguments{
\item{connection}{Defaults to NULL. If NULL, uses local SQLite database. If given, must be a connection object or a list with relevant connection settings (see example).}

\item{RSQLite}{Defaults to NULL, expected either NULL or logical. If set to \code{FALSE}, details on the database connection must be given either as a named list in the connection parameter, or with \code{tw_set_cache_db()} as environment variables.}

\item{language}{Defaults to language set with \code{tw_set_language()}; if not set, "en". Use "all_available" to keep all languages. For available language values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}
}
\value{
A connection object.
}
\description{
Return a connection to be used for caching
}
\examples{
\donttest{
if (interactive()) {
  cache_connection <- pool::dbPool(
    RSQLite::SQLite(), # or e.g. odbc::odbc(),
    Driver =  ":memory:", # or e.g. "MariaDB",
    Host = "localhost",
    database = "example_db",
    UID = "example_user",
    PWD = "example_pwd"
  )
  tw_connect_to_cache(cache_connection)


  db_settings <- list(
    driver = "MySQL",
    host = "localhost",
    port = 3306,
    database = "tidywikidatar",
    user = "secret_username",
    pwd = "secret_password"
  )

  tw_connect_to_cache(db_settings)
}
}

}
