% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get.R
\name{tw_get_property}
\alias{tw_get_property}
\title{Get Wikidata property of an item}
\usage{
tw_get_property(
  id,
  p,
  language = "all_available",
  cache = NULL,
  overwrite_cache = FALSE,
  wait = 0
)
}
\arguments{
\item{id}{A characther vector, must start with Q, e.g. "Q254" for Wolfgang Amadeus Mozart.}

\item{p}{A character vector, a property. Must always start with the capital letter "P", e.g. "P31" for "instance of".}

\item{language}{Defaults to "all_available". It should be relevant only for caching purposes. For a full list of available values, see: https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}
}
\value{
A tibble, corresponding to the value for the given property.
}
\description{
Get Wikidata property of an item
}
\examples{
# Who were the doctoral advisors - P184 - of Margaret Mead - Q180099?
advisors <- tw_get_property(id = "Q180099", p = "P184")
advisors

tw_get_label(advisors)

# It is also possible to get one property for many id

tw_get_property(
  id = c(
    "Q180099",
    "Q228822"
  ),
  p = "P31"
)

# Or many properties for a single id

tw_get_property(
  id = "Q180099",
  p = c("P21", "P31")
)
}
