% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_check.R
\name{tw_check_search}
\alias{tw_check_search}
\title{Checks if an input is a search; if not, it tries to return a search}
\usage{
tw_check_search(search, language = "en", limit = 10, wait = 0, cache = NULL)
}
\arguments{
\item{search}{A data frame generated by \code{tw_search()}, or a search query. If a data frame is given, language and limits are ignore.}

\item{language}{Language to be used for the search.}

\item{limit}{Maximum numbers of responses to be given.}

\item{wait}{In seconds, defaults to 0.1. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied.}

\item{cache}{Logical, defaults to TRUE.}
}
\value{
A data frame with three columns, \code{id}, \code{label}, and \code{description}, filtered by the above criteria.
}
\description{
Mostly used as a convenience function inside other functions to have consistent inputs.
}
\examples{
# The following two lines should give the same result.

tw_check_search("Sylvia Pankhurst")
tw_check_search(tw_search("Sylvia Pankhurst"))
}
