% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvecost.R
\name{solvecost_solids}
\alias{solvecost_solids}
\title{Determine solids disposal cost}
\source{
https://water.mecc.edu/courses/ENV295Residuals/lesson3b.htm#:~:text=From\%20the\%20diagram\%2C\%20for\%20example,million\%20gallons\%20of\%20water\%20produced.
}
\usage{
solvecost_solids(
  alum = 0,
  ferricchloride = 0,
  ferricsulfate = 0,
  flow,
  turb,
  b = 1.5,
  cost,
  time = "day"
)
}
\arguments{
\item{alum}{Hydrated aluminum sulfate Al2(SO4)3*14H2O + 6HCO3 -> 2Al(OH)3(am) +3SO4 + 14H2O + 6CO2}

\item{ferricchloride}{Ferric Chloride FeCl3 + 3HCO3 -> Fe(OH)3(am) + 3Cl + 3CO2}

\item{ferricsulfate}{Amount of ferric sulfate added in mg/L: Fe2(SO4)3*8.8H2O + 6HCO3 -> 2Fe(OH)3(am) + 3SO4 + 8.8H2O + 6CO2}

\item{flow}{Plant flow in MGD}

\item{turb}{Turbidity removed in NTU}

\item{b}{Correlation factor from turbidity to suspended solids. Defaults to 1.5.}

\item{cost}{Disposal cost in $/lb}

\item{time}{Desired output units, one of c("day", "month", "year"). Defaults to "day".}
}
\value{
A numeric value for disposal costs, $/time.
}
\description{
This function takes coagulant doses in mg/L as chemical, removed turbidity, and cost ($/lb) to determine disposal cost.
}
\examples{
alum_solidscost <- solvecost_solids(alum = 50, flow = 10, turb = 2, cost = 0.05)

library(dplyr)
cost_data <- tibble(
  alum = seq(10, 50, 10),
  flow = 10
) \%>\%
  mutate(costs = solvecost_solids(alum = alum, flow = flow, turb = 2, cost = 0.05))

}
