% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvemass.R
\name{solvemass_solids}
\alias{solvemass_solids}
\title{Determine solids lb/day}
\source{
https://water.mecc.edu/courses/ENV295Residuals/lesson3b.htm#:~:text=From%20the%20diagram%2C%20for%20example,million%20gallons%20of%20water%20produced.
}
\usage{
solvemass_solids(
  alum = 0,
  ferricchloride = 0,
  ferricsulfate = 0,
  flow,
  turb,
  b = 1.5
)
}
\arguments{
\item{alum}{Amount of hydrated aluminum sulfate added in mg/L as chemical: Al2(SO4)3*14H2O + 6HCO3 -> 2Al(OH)3(am) +3SO4 + 14H2O + 6CO2}

\item{ferricchloride}{Amount of ferric chloride added in mg/L as chemical: FeCl3 + 3HCO3 -> Fe(OH)3(am) + 3Cl + 3CO2}

\item{ferricsulfate}{Amount of ferric sulfate added in mg/L as chemical: Fe2(SO4)3*8.8H2O + 6HCO3 -> 2Fe(OH)3(am) + 3SO4 + 8.8H2O + 6CO2}

\item{flow}{Plant flow in MGD}

\item{turb}{Turbidity removed in NTU}

\item{b}{Correlation factor from turbidity to suspended solids. Defaults to 1.5.}
}
\value{
A numeric value for solids mass in lb/day.
}
\description{
This function takes coagulant doses in mg/L as chemical, removed turbidity, and plant flow as MGD to determine solids production.
}
\examples{
solids_mass <- solvemass_solids(alum = 50, flow = 10, turb = 20)

library(dplyr)
mass_data <- tibble(
  alum = seq(10, 50, 10),
  flow = 10
) \%>\%
  mutate(mass = solvemass_solids(alum = alum, flow = flow, turb = 20))
#'
}
