% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvedose_ph_alk.R
\name{solvedose_alk}
\alias{solvedose_alk}
\title{Calculate a desired chemical dose for a target alkalinity}
\usage{
solvedose_alk(water, target_alk, chemical)
}
\arguments{
\item{water}{Source water of class "water" created by \code{\link{define_water}}}

\item{target_alk}{The final alkalinity in mg/L as CaCO3 to be achieved after the specified chemical is added.}

\item{chemical}{The chemical to be added. Current supported chemicals include:
acids: "hcl", "h2so4", "h3po4", "co2", bases: "naoh", "na2co3", "nahco3", "caoh2", "mgoh2"}
}
\value{
A numeric value for the required chemical dose.
}
\description{
This function calculates the required amount of a chemical to dose based on a target alkalinity and existing water quality.
Returns numeric value for dose in mg/L. Uses uniroot on the chemdose_ph function.
}
\examples{
dose_required <- define_water(ph = 7.9, temp = 22, alk = 100, 80, 50) \%>\%
  solvedose_alk(target_alk = 150, "naoh")
}
\seealso{
\code{\link{define_water}}
}
