% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/converter.R
\name{as.treedata}
\alias{as.treedata}
\alias{as.treedata.tbl_tree}
\title{as.treedata}
\usage{
as.treedata(tree, ...)

\method{as.treedata}{tbl_tree}(tree, ...)
}
\arguments{
\item{tree}{tree object}

\item{...}{additional parameters}
}
\value{
treedata object
}
\description{
convert a tree object to treedata object
}
\examples{
library(ape)
set.seed(2017)
tree <- rtree(4)
d <- tibble(label = paste0('t', 1:4),
           trait = rnorm(4))
x <- as_data_frame(tree)
full_join(x, d, by = 'label') \%>\% as.treedata
}
