% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{gtfs_as_sf}
\alias{gtfs_as_sf}
\title{Convert stops and shapes to Simple Features}
\usage{
gtfs_as_sf(gtfs_obj, skip_shapes = FALSE, crs = NULL, quiet = TRUE)
}
\arguments{
\item{gtfs_obj}{gtfs feed (tidygtfs object, created by \code{\link[=read_gtfs]{read_gtfs()}})}

\item{skip_shapes}{if TRUE, shapes are not converted. Default FALSE.}

\item{crs}{optional coordinate reference system (used by sf::st_transform) to transform
lon/lat coordinates of stops and shapes}

\item{quiet}{boolean whether to print status messages}
}
\value{
tidygtfs object with stops and shapes as sf dataframes
}
\description{
Stops are converted to POINT sf data frames. Shapes are converted to a
LINESTRING data frame. Note that this function replaces stops and shapes
tables in \code{gtfs_obj}.
}
\seealso{
\code{\link{sf_as_tbl}}, \code{\link{stops_as_sf}}, \code{\link{shapes_as_sf}}
}
