% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice-head-tail.R, R/slice-min-max.R,
%   R/slice.R, R/slice_sample.R
\name{slice_head}
\alias{slice_head}
\alias{slice_tail}
\alias{slice_max}
\alias{slice_min}
\alias{slice}
\alias{slice_sample}
\title{Choose rows in a data.table}
\usage{
slice_head(.df, n = 5, .by = NULL)

slice_tail(.df, n = 5, .by = NULL)

slice_max(.df, order_by, n = 1, ..., with_ties = TRUE, .by = NULL)

slice_min(.df, order_by, n = 1, ..., with_ties = TRUE, .by = NULL)

slice(.df, ..., .by = NULL)

slice_sample(.df, n, prop, weight_by = NULL, replace = FALSE, .by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{n}{Number of rows to grab}

\item{.by}{Columns to group by}

\item{order_by}{Variable to arrange by}

\item{...}{Integer row values}

\item{with_ties}{Should ties be kept together. The default \code{TRUE} may return
can return multiple rows if they are equal. Use \code{FALSE} to ignore ties.}

\item{prop}{The proportion of rows to select}

\item{weight_by}{Sampling weights}

\item{replace}{Should sampling be performed with (\code{TRUE}) or without (\code{FALSE}, default) replacement}
}
\description{
Choose rows in a data.table.
Grouped data.tables grab rows within each group.
}
\examples{
df <- data.table(
  x = 1:4,
  y = 5:8,
  z = c("a", "a", "a", "b")
)

df \%>\%
  slice(1:3)

df \%>\%
  slice(1, 3)

df \%>\%
  slice(1:2, .by = z)

df \%>\%
  slice_head(1, .by = z)

df \%>\%
  slice_tail(1, .by = z)

df \%>\%
  slice_max(order_by = x, .by = z)

df \%>\%
  slice_min(order_by = y, .by = z)
}
