% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate.R
\name{relocate.}
\alias{relocate.}
\title{Relocate a column to a new position}
\usage{
relocate.(.df, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{A selection of columns to move. \code{tidyselect} compatible.}

\item{.before}{Column to move selection before}

\item{.after}{Column to move selection after}
}
\description{
Move a column or columns to a new position
}
\examples{
test_df <- data.table(
  a = 1:3,
  b = 1:3,
  c = c("a", "a", "b"),
  d = c("a", "a", "b")
)

test_df \%>\%
  relocate.(c, .before = b)

test_df \%>\%
  relocate.(a, b, .after = c)

test_df \%>\%
  relocate.(where(is.numeric), .after = c)
}
