% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag_lead.R
\name{lags.}
\alias{lags.}
\alias{leads.}
\title{Get lagging or leading values}
\usage{
lags.(x, n = 1L, default = NA)

leads.(x, n = 1L, default = NA)
}
\arguments{
\item{x}{a vector of values}

\item{n}{a positive integer of length 1, giving the number of positions to lead or lag by}

\item{default}{value used for non-existent rows. Defaults to NA.}
}
\description{
Find the "previous" or "next" values in a vector.
Useful for comparing values behind or ahead of the current values.
}
\examples{
x <- 1:5

leads.(x, 1)
lags.(x, 1)

# Also works inside of `mutate.()`
test_df <- tidytable(x = 1:5)

test_df \%>\%
  mutate.(lag_x = lags.(x))

}
