% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case.R
\name{case.}
\alias{case.}
\title{Case when}
\usage{
case.(..., default = NA)
}
\arguments{
\item{...}{Sequence of condition/value designations}

\item{default}{Default value. Set to NA by default.}
}
\description{
This function allows you to use multiple if/else statements in one call.

Note that this function is called differently than \code{dplyr::case_when}. See examples.
}
\examples{
test_df <- tidytable(
  a = 1:10,
  b = 11:20,
  c = c(rep("a", 6), rep("b", 4)),
  d = c(rep("a", 4), rep("b", 6)))

test_df \%>\%
  mutate.(x = case.(b < 13, 3,
                    a > 4, 2,
                    default = 10))
test_df \%>\%
  mutate.(x = case.(c == "a", "a",
                    default = d))
}
