% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_correlation.R
\name{report_correlation}
\alias{report_correlation}
\title{Report function for correlations}
\usage{
report_correlation(identifier, term, term_nr,
  results = getOption("tidystats_list"))
}
\arguments{
\item{identifier}{A character string identifying the model.}

\item{term}{A character string indicating the term you want to report.}

\item{term_nr}{A number indicating the term you want to report.]}

\item{results}{A tidystats list.}
}
\description{
Function to report a correlation in APA style.
}
\examples{
# Read in a list of results
results <- read_stats(system.file("results.csv", package = "tidystats"))

# Set the default tidystats list in options()
options(tidystats_list = results)

# Report results
report(identifier = "correlation_pearson")
report(identifier = "correlation_spearman")
report(identifier = "correlation_kendall")

}
