% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_stats_to_model.R
\name{add_stats_to_model}
\alias{add_stats_to_model}
\title{Add statistical output to a model in a tidy stats list}
\usage{
add_stats_to_model(output, results, identifier, statistics = NULL)
}
\arguments{
\item{output}{output of a statistical test.}

\item{results}{a tidy stats list.}

\item{identifier}{a character string identifying the model.}

\item{statistics}{a vector of statistics to select from the output and add to the model in the tidy stats list.}
}
\description{
\code{add_stats_to_model} adds output to a model in a tidy results list. Sometimes you have to run additional analyses on the output of a statistical test, so you want to add these results to an existing model in a tidy stats list.
}
\examples{
library(magrittr)

# Create an empty list to store the results in
results <- list()

# Conduct a regression analysis
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2, 10, 20, labels = c("Ctl","Trt"))
weight <- c(ctl, trt)

model <- lm(weight ~ group)

# Add output to the results list
results <- add_stats(model, results, identifier = "M1")

# Get confidence intervals of the model
model_CIs <- confint(model)

# Produce a tidy data frame of the CIs and add it to the results list
results <- model_CIs \%>\%
  tidy_stats_confint() \%>\%
  add_stats_to_model(results, identifier = "M1")

}
