% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has.R
\name{\%has\%}
\alias{\%has\%}
\title{Test sq object for presence of given motifs}
\usage{
x \%has\% y
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{y}{[\code{character}]\cr
Motifs to be searched for.}
}
\value{
A \code{\link{logical}} vector of the same length as input \code{sq},
indicating which elements contain all given motifs.
}
\description{
Tests if elements of a \code{\link[=sq-class]{sq}} object
contain given motifs.
}
\details{
This function allows testing if elements of a \code{sq} object contain the
given motif or motifs. It returns a \code{logical} value for every element
of the \code{sq} object - \code{TRUE} if tested sequence contains searched
motif and \code{FALSE} otherwise. When multiple motifs are searched,
\code{TRUE} will be returned only for sequences that contain all given
motifs.

This function only indicates if a motif is present within a sequence, to find
all motifs and their positions within sequences use
\code{\link{find_motifs}}.
}
\section{Motif capabilities and restrictions}{

There are more options than to simply create a motif that is a string
representation of searched subsequence. For example, when using this function
with any of standard types, i.e. \strong{ami}, \strong{dna} or \strong{rna},
the user can create a motif with ambiguous letters. In this case the engine
will try to match any of possible meanings of this letter. For example, take
"B" from extended DNA alphabet. It means "not A", so it can be matched with
"C", "G" and "T", but also "B", "Y" (either "C" or "T"), "K" (either "G" or
"T") and "S" (either "C" or "G").

Full list of ambiguous letters with their meaning can be found on IUPAC site.

Motifs are also restricted in that the alphabets of \code{sq} objects on
which search operations are conducted cannot contain "^" and "$" symbols.
These two have a special meaning - they are used to indicate beginning and
end of sequence respectively and can be used to limit the position of matched
subsequences.
}

\examples{
# Creating objects to work on:
sq_dna <- sq(c("ATGCAGGA", "GACCGNBAACGAN", "TGACGAGCTTAG"),
             alphabet = "dna_bsc")
sq_ami <- sq(c("MIAANYTWIL","TIAALGNIIYRAIE", "NYERTGHLI", "MAYXXXIALN"),
             alphabet = "ami_ext")
sq_atp <- sq(c("mAmYmY", "nbAnsAmA", ""),
             alphabet = c("mA", "mY", "nbA", "nsA"))

# Testing if DNA sequences contain motif "ATG":
sq_dna \%has\% "ATG"

# Testing if DNA sequences begin with "ATG":
sq_dna \%has\% "^ATG"

# Testing if DNA sequences end with "TAG" (one of the stop codons):
sq_dna \%has\% "TAG$"

# Test if amino acid sequences contain motif of two alanines followed by
# aspartic acid or asparagine ("AAB" motif matches "AAB", "AAD" and "AAN"):
sq_ami \%has\% "AAB"

# Test if amino acid sequences contain both motifs:
sq_ami \%has\% c("AAXG", "MAT")

# Test for sequences with multicharacter alphabet:
sq_atp \%has\% c("nsA", "mYmY$")

}
\seealso{
Functions interpreting sq in biological context:
\code{\link{complement}()},
\code{\link{find_motifs}()},
\code{\link{translate}()}
}
\concept{bio_functions}
