% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_sq.R
\name{random_sq}
\alias{random_sq}
\title{Generate random sequences}
\usage{
random_sq(n, len, alphabet, sd = NULL, use_gap = FALSE)
}
\arguments{
\item{n}{[\code{integer(1)}]\cr
A number of sequences to generate - must be non-negative.}

\item{len}{[\code{integer(1)}]\cr
Length of each sequence if \code{sd} not specified and mean length of
sequences if \code{sd} specified - must be non-negative.}

\item{alphabet}{[\code{character}]\cr
If provided value is a single string, it will be interpreted as type (see
details). If provided value has length greater than one, it will be treated
as atypical alphabet for \code{sq} object and \code{sq} type will be
\code{atp}.}

\item{sd}{[\code{integer(1)}]\cr
If specified, gives standard deviation of length of generated sequences -
must be non-negative.}

\item{use_gap}{[\code{logical(1)}]\cr
If \code{TRUE}, sequences will be generated with random gaps inside
(commonly denoted as "\code{-}").}
}
\value{
An object of class \code{sq} with type as specified.
}
\description{
Generates an \code{\link[=sq-class]{sq}} object with specified
number of sequences of given length and alphabet.
}
\details{
Letter '*' is not used in generating \strong{ami} sequences. If parameter
\code{sd} is passed, then all generated negative values are replaced with 0s.
}
\examples{
# Setting seed for reproducibility
set.seed(16)

# Generating random sequences
random_sq(10, 10, "ami_bsc")
random_sq(25, 18, "rna_bsc", sd = 6)
random_sq(50, 8, "dna_ext", sd = 3)
random_sq(6, 100, "ami_bsc", use_gap = TRUE)

# Passing whole alphabet instead of type
random_sq(4, 12, c("Pro", "Gly", "Ala", "Met", "Cys"))

# Generating empty sequences (why would anyone though)
random_sq(8, 0, "rna_ext")

}
\seealso{
Functions from input module:
\code{\link{import_sq}()},
\code{\link{read_fasta}()},
\code{\link{sq}()}
}
\concept{input_functions}
