% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{as_tidyplot}
\alias{as_tidyplot}
\title{Convert ggplot to tidyplot}
\usage{
as_tidyplot(gg, width = 50, height = 50, dodge_width = 0.8)
}
\arguments{
\item{gg}{A ggplot.}

\item{width}{Width of the plot area. Defaults to \code{50}.}

\item{height}{Height of the plot area. Defaults to \code{50}.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults to \code{0.8}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Convert ggplot to tidyplot
}
\examples{
gg <-
  study \%>\%
  ggplot2::ggplot(ggplot2::aes(x = treatment, y = score, color = treatment)) +
  ggplot2::geom_point()

gg

gg \%>\% as_tidyplot()

}
