% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-misc.R
\name{add_line}
\alias{add_line}
\alias{add_area}
\title{Add line or area}
\usage{
add_line(
  plot,
  group,
  dodge_width = NULL,
  linewidth = 0.25,
  preserve = "total",
  ...
)

add_area(
  plot,
  group,
  dodge_width = NULL,
  linewidth = 0.25,
  alpha = 0.4,
  preserve = "total",
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{group}{Variable in the dataset to be used for grouping.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults to \code{0.8}.}

\item{linewidth}{Thickness of the line in points (pt). Typical values range between \code{0.25} and \code{1}.}

\item{preserve}{Should dodging preserve the \code{"total"} width of all elements at
a position, or the width of a \code{"single"} element?}

\item{...}{Arguments passed on to the \code{geom} function.}

\item{alpha}{A \code{number} between \code{0} and \code{1} for the opacity of an object. A value of \code{0} is completely transparent, \code{1} is completely opaque.}
}
\value{
A \code{tidyplot} object.
}
\description{
\code{add_line()} and \code{add_area()} connect individual data points, which is rarely needed.
In most cases, you are probably looking for \code{add_sum_line()}, \code{add_mean_line()}, \code{add_sum_area()} or \code{add_mean_area()}.
}
\examples{
# Paired data points
study \%>\%
  tidyplot(x = treatment, y = score, color = group) \%>\%
  reorder_x_axis_labels("A", "C", "B", "D") \%>\%
  add_data_points() \%>\%
  add_line(group = participant, color = "grey")

study \%>\%
  tidyplot(x = treatment, y = score) \%>\%
  reorder_x_axis_labels("A", "C", "B", "D") \%>\%
  add_data_points() \%>\%
  add_area(group = participant)

}
