% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_ndr.R
\name{summarize_ndr}
\alias{summarize_ndr}
\title{Count the Number of Outcomes Based on a Specified Level}
\usage{
summarize_ndr(..., level, names)
}
\arguments{
\item{...}{Dataframes to be summarized.}

\item{level}{The level at which the summary should be performed. The options
are "ip" (or "country"), "state", "lga" or "facility".}

\item{names}{The names to be passed to the summary columns created in
the output}
}
\value{
summarize_ndr
}
\description{
The \code{summarize_ndr()} function counts the number of occurrence of
specified level for each of the supplied dataframe. It then combines the
given dataframes into a single table. It also adds a "Total" roll that
adds all the rows for each of the numeric columns.
}
\examples{
new <- tx_new(ndr_example)
curr <- tx_curr(ndr_example)

summarize_ndr(
  new,
  curr,
  level = "state",
  names = c("tx_new", "tx_curr")
)

### summarize for only one dataframe
summarize_ndr(
  new,
  level = "ip",
  names = "tx_new"
)
}
