% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_azure_openai.R
\name{list_azure_openai_batches}
\alias{list_azure_openai_batches}
\title{List Azure OpenAI Batch Requests}
\usage{
list_azure_openai_batches(
  .endpoint_url = Sys.getenv("AZURE_ENDPOINT_URL"),
  .limit = 20,
  .max_tries = 3,
  .timeout = 60
)
}
\arguments{
\item{.endpoint_url}{Base URL for the API (default:  Sys.getenv("AZURE_ENDPOINT_URL")).}

\item{.limit}{Maximum number of batches to retrieve (default: 20).}

\item{.max_tries}{Maximum retry attempts for requests (default: 3).}

\item{.timeout}{Request timeout in seconds (default: 60).}
}
\value{
A tibble with batch details: batch ID, status, creation time, expiration time,
and request counts (total, completed, failed).
}
\description{
Retrieves batch request details from the Azure OpenAI Batch API.
}
