% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_functions.R
\name{groq}
\alias{groq}
\title{Call the Groq API to interact with fast opensource models on Groq}
\usage{
groq(
  .llm,
  .model = "llama-3.2-90b-text-preview",
  .max_tokens = 1024,
  .temperature = NULL,
  .top_p = NULL,
  .frequency_penalty = NULL,
  .presence_penalty = NULL,
  .api_url = "https://api.groq.com/",
  .timeout = 60,
  .verbose = FALSE,
  .wait = TRUE,
  .min_tokens_reset = 0L
)
}
\arguments{
\item{.llm}{An existing LLMMessage object or an initial text prompt.}

\item{.model}{The model identifier (default: "llama-3.2-90b-text-preview").}

\item{.max_tokens}{The maximum number of tokens to generate (default: 1024).}

\item{.temperature}{Control for randomness in response generation (optional).}

\item{.top_p}{Nucleus sampling parameter (optional).}

\item{.frequency_penalty}{Controls repetition frequency (optional).}

\item{.presence_penalty}{Controls how much to penalize repeating content (optional)}

\item{.api_url}{Base URL for the API (default: "https://api.anthropic.com/v1/messages").}

\item{.timeout}{Request timeout in seconds (default: 60).}

\item{.verbose}{Should additional information be shown after the API call}

\item{.wait}{Should we wait for rate limits if necessary?}

\item{.min_tokens_reset}{How many tokens should be remaining to wait until we wait for token reset?}
}
\value{
Returns an updated LLMMessage object.
}
\description{
Call the Groq API to interact with fast opensource models on Groq
}
