% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyllm.R
\name{df_llm_message}
\alias{df_llm_message}
\title{Convert a Data Frame to an LLMMessage Object}
\usage{
df_llm_message(.df)
}
\arguments{
\item{.df}{A data frame with at least two rows and columns \code{role} and \code{content}.
The column \code{role} should contain values from "user", "assistant", or "system",
and \code{content} should be of type character.}
}
\value{
An LLMMessage object containing the structured messages as per the input data frame.
}
\description{
This function takes a data frame and converts it into an LLMMessage object
representing a conversation history. The data frame should contain specific
columns (\code{role} and \code{content}) with each row representing a message in the
conversation.
}
\examples{
# Example data frame with role and content
df_example <- data.frame(
 role = c("system", "user", "assistant","user"),
 content = c("You allways only answer with two words", 
              "Why is the sky blue?", 
              "Rayleigh scattering",
              "Why is the sun yellow?"),
 stringsAsFactors = FALSE
)
df_llm_message(df_example)

}
