% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_functions.R
\name{claude}
\alias{claude}
\title{Call the Anthropic API to interact with Claude models}
\usage{
claude(
  .llm,
  .model = "claude-3-5-sonnet-20240620",
  .max_tokens = 1024,
  .temperature = NULL,
  .top_k = NULL,
  .top_p = NULL,
  .metadata = NULL,
  .stop_sequences = NULL,
  .tools = NULL,
  .api_url = "https://api.anthropic.com/",
  .verbose = FALSE,
  .wait = TRUE,
  .min_tokens_reset = 0L,
  .timeout = 60,
  .stream = FALSE
)
}
\arguments{
\item{.llm}{An existing LLMMessage object or an initial text prompt.}

\item{.model}{The model identifier (default: "claude-3-5-sonnet-20240620").}

\item{.max_tokens}{The maximum number of tokens to generate (default: 1024).}

\item{.temperature}{Control for randomness in response generation (optional).}

\item{.top_k}{Top k sampling parameter (optional).}

\item{.top_p}{Nucleus sampling parameter (optional).}

\item{.metadata}{Additional metadata for the request (optional).}

\item{.stop_sequences}{Sequences that stop generation (optional).}

\item{.tools}{Additional tools used by the model (optional).}

\item{.api_url}{Base URL for the API (default: "https://api.anthropic.com/v1/messages").}

\item{.verbose}{Should additional information be shown after the API call}

\item{.wait}{Should we wait for rate limits if necessary?}

\item{.min_tokens_reset}{How many tokens should be remaining to wait until we wait for token reset?}

\item{.timeout}{Request timeout in seconds (default: 60).}

\item{.stream}{Stream back the response piece by piece (default: FALSE).}
}
\value{
Returns an updated LLMMessage object.
}
\description{
Call the Anthropic API to interact with Claude models
}
