% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_factory.R
\name{query_api}
\alias{query_api}
\title{Execute a geocoder API query}
\usage{
query_api(
  api_url,
  query_parameters,
  mode = "single",
  batch_file = NULL,
  input_list = NULL,
  content_encoding = "UTF-8",
  timeout = 20,
  method = ""
)
}
\arguments{
\item{api_url}{Base URL of the API. query parameters are appended to this}

\item{query_parameters}{api query parameters in the form of a named list}

\item{mode}{determines the type of query to execute\preformatted{- "single": geocode a single input (all methods)
- "list": batch geocode a list of inputs (ex. geocodio)
- "file": batch geocode a file of inputs (ex. census)
}}

\item{batch_file}{a csv file of input data to upload (for \code{mode = 'file'})}

\item{input_list}{a list of input data (for \code{mode = 'list'})}

\item{content_encoding}{Encoding to be used for parsing content}

\item{timeout}{timeout in minutes}

\item{method}{if 'mapquest' or 'arcgis' then the query status code is changed appropriately}
}
\value{
a named list containing the response content (\code{content}) and the HTTP request status (\code{status})
}
\description{
The \link{get_api_query} function can create queries for this
function to execute.
}
\examples{
\donttest{
raw1 <- query_api("http://nominatim.openstreetmap.org/search", 
   get_api_query("osm", list(address = 'Hanoi, Vietnam')))
   
raw1$status
   
extract_results('osm', jsonlite::fromJSON(raw1$content))

raw2 <- query_api("http://nominatim.openstreetmap.org/reverse", 
   get_api_query("osm", custom_parameters = list(lat = 38.895865, lon = -77.0307713)))
   
extract_reverse_results('osm', jsonlite::fromJSON(raw2$content))
}

}
\seealso{
\link{get_api_query} \link{extract_results} \link{extract_reverse_results} \link{geo} \link{reverse_geo}
}
