% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{api_parameter_reference}
\alias{api_parameter_reference}
\title{Geocoder service API parameter reference}
\format{
A tibble dataframe
\describe{
\item{method}{Geocoder service name}
\item{generic_name}{Universal parameter name}
\item{api_name}{Name of the parameter for the specified geocoder service}
\item{default_value}{Default value of the parameter}
\item{required}{Is the parameter required by the specified geocoder service?}
}
}
\usage{
api_parameter_reference
}
\description{
This dataset contains the mapping that allows this package to use a
universal syntax to specify parameters for different geocoder services.
Note that latitude and longitude input parameters for reverse geocoding
are not in this dataset and are instead handled directly by the \link{reverse_geo} function.

The \code{generic_name} column is a universal parameter name that is shared between services.
The \code{api_name} column is the parameter name for the given geocoder service specified by the
\code{method} column. When \code{generic_name} is missing
this means the parameter is specific to that geocoder service.

While the "census" and "google" services do not have a \code{limit}
argument in their APIs, tidygeocoder provides a passthrough so you can still
use the \code{limit} argument in \link{geo} and \link{reverse_geo} to limit the
number of results per input.

Note that some geocoder services only use the \code{limit} argument for forward geocoding.
Refer to API documentation of each service for more information.

Reference the documentation for \link{geo} and \link{reverse_geo} for more information.
Also reference \code{vignette("tidygeocoder")} for more details on constructing API queries.
}
\details{
The API documentation for each service is linked to below:
\itemize{
\item \href{https://nominatim.org/release-docs/develop/api/Search/}{Nominatim}
\item \href{https://www.census.gov/programs-surveys/geography/technical-documentation/complete-technical-documentation/census-geocoder.html}{US Census}
\item \href{https://developers.arcgis.com/rest/geocode/api-reference/overview-world-geocoding-service.htm}{ArcGIS}
\item \href{https://www.geocod.io/docs/}{Geocodio}
\item \href{https://locationiq.com/docs}{Location IQ}
\item \href{https://developers.google.com/maps/documentation/geocoding/overview}{Google}
\item \href{https://opencagedata.com/api}{OpenCage}
\item \href{https://docs.mapbox.com/api/search/geocoding/}{Mapbox}
\item \href{https://developer.here.com/documentation/geocoding-search-api/dev_guide/index.html}{HERE}
\item \href{https://developer.tomtom.com/search-api/search-api-documentation-geocoding/geocode}{TomTom}
\item \href{https://developer.mapquest.com/documentation/geocoding-api/}{MapQuest}
\item \href{https://docs.microsoft.com/en-us/bingmaps/rest-services/locations/}{Bing}
}
}
\seealso{
\link{geo} \link{reverse_geo} \link{get_api_query} \link{query_api} \link{min_time_reference} \link{batch_limit_reference}
}
\keyword{datasets}
