% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_cascade.R
\name{geo_cascade}
\alias{geo_cascade}
\title{Geocode addresses}
\usage{
geo_cascade(address, lat = lat, long = long, verbose = FALSE)
}
\arguments{
\item{address}{single line address.}

\item{lat}{name of latitude field}

\item{long}{name of longitude field}

\item{verbose}{logical. If TRUE outputs logs.}
}
\value{
latitude and longitude coordinates and the geocoder method used (geo_method) in tibble format (3 columns)
}
\description{
First attempts to use the US Census Geocoder (geo_census) method
and then uses the Nominatim/OSM (geo_osm) method if the census method failed.
Returns latitude and longitude coordinates and the method used to return results (OSM or Census)
}
\examples{
\donttest{
geo_cascade("1600 Pennsylvania Ave Washington, DC")
geo_cascade("Paris, France")
}
}
