% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy_dt.R
\name{dummy_dt}
\alias{dummy_dt}
\title{Fast creation of dummy variables}
\usage{
dummy_dt(data, ..., longname = TRUE)
}
\arguments{
\item{data}{data.frame}

\item{...}{Columns you want to create dummy variables from.
Very flexible, find in the examples.}

\item{longname}{logical. Should the output column labeled with the
original column name? Default uses \code{TRUE}.}
}
\value{
data.table
}
\description{
Quickly create dummy (binary) columns from character and factor type columns in the inputted data (and numeric columns if specified.)
This function is useful for statistical analysis when you want binary columns rather than character columns.
}
\details{
If no columns provided, will return the original data frame.

This function is inspired by \pkg{fastDummies} package, but provides
simple and precise usage, whereas \code{fastDummies::dummy_cols} provides more
features for statistical usage.
}
\examples{
iris \%>\% dummy_dt(Species)
iris \%>\% dummy_dt(Species,longname = FALSE)

mtcars \%>\% head() \%>\% dummy_dt(vs,am)
mtcars \%>\% head() \%>\% dummy_dt("cyl|gear")
}
\seealso{
\code{\link[fastDummies]{dummy_cols}}
}
