% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.cor.R
\name{.fit.cor}
\alias{.fit.cor}
\title{Pearson's correlation for \code{tidyfit}}
\usage{
\method{.fit}{cor}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Calculates Pearson's correlation coefficient on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}

The function provides a wrapper for \code{stats::cor.test}. See \code{?cor.test} for more details.

\strong{Implementation}

Results can be viewed using \code{coef}.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

# Stand-alone function
fit <- m("cor", Return ~ `Mkt-RF` + HML + SMB, data)
fit

# Within 'regress' function
fit <- regress(data, Return ~ ., m("cor"), .mask = c("Date", "Industry"))
tidyr::unnest(coef(fit), model_info)

}
\seealso{
\code{\link{.fit.chisq}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
