% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lag_columns.R
\name{add_lag_columns}
\alias{add_lag_columns}
\title{Add Lagged Versions of Columns to a Data Frame}
\usage{
add_lag_columns(
  data,
  cols,
  by = NULL,
  lag,
  max_lag = lag,
  drop_na = TRUE,
  data_options = NULL
)
}
\arguments{
\item{data}{A data frame containing the columns to be lagged.}

\item{cols}{A character vector specifying the names of the columns to lag.}

\item{by}{An optional column by which to group the data when applying the lag.
Default is \code{NULL}, meaning no grouping.}

\item{lag}{The number of periods to lag the columns by. Must be non-negative.}

\item{max_lag}{An optional maximum lag period. The default is equal to \code{lag}.}

\item{drop_na}{A logical value indicating whether to drop rows with missing
values in the lagged columns. Default is \code{TRUE}.}

\item{data_options}{A list of additional options for data processing, such as
the \code{date} column. If \code{NULL}, defaults are used.}
}
\value{
A data frame with lagged versions of the specified columns appended,
optionally grouped by another column.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function adds lagged versions of specified columns to a data frame. Optionally,
the operation can be grouped by another column and allows for flexible handling
of missing values. The lag is applied based on the \code{date} column in the data frame.
}
\examples{
# Create a sample data frame
data <- tibble::tibble(
  permno = rep(1:2, each = 10),
  date = rep(seq.Date(as.Date('2023-01-01'), by = "month", length.out = 10), 2),
  bm = runif(20, 0.5, 1.5),
  size = runif(20, 100, 200)
)

# Add lagged columns for 'bm' and 'size' with a 3-month lag, grouped by 'permno'
data |>
  add_lag_columns(c("bm", "size"), lag = months(3), by = "permno")

# Introduce missing values in the data
data$bm[c(3, 5, 7, 15, 18)] <- NA
data$size[c(2, 4, 8, 13)] <- NA

# Add lagged columns with NA values removed
data |>
  add_lag_columns(c("bm", "size"), lag = months(3), by = permno)

}
