% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_cuminc.R
\name{add_cuminc}
\alias{add_cuminc}
\alias{add_p.tbl_cuminc}
\alias{add_n.tbl_cuminc}
\alias{add_nevent.tbl_cuminc}
\alias{inline_text.tbl_cuminc}
\title{Additional Functions for \code{tbl_cuminc()}}
\usage{
\method{add_p}{tbl_cuminc}(x, pvalue_fun = gtsummary::style_pvalue, ...)

\method{add_n}{tbl_cuminc}(x, location = NULL, ...)

\method{add_nevent}{tbl_cuminc}(x, location = NULL, ...)

\method{inline_text}{tbl_cuminc}(x, time = NULL, column = NULL, outcome = NULL, level = NULL, ...)
}
\arguments{
\item{x}{object of class 'tbl_cuminc'}

\item{pvalue_fun}{function to style/format p-values. Default is
\code{gtsummary::style_pvalue}}

\item{...}{These dots are for future extensions and must be empty.}

\item{location}{location to place Ns. When \code{"label"} total Ns are placed
on each variable's label row. When \code{"level"} level counts are placed on
the variable level for categorical variables, and total N on the
variable's label row for continuous.}

\item{time}{time of statistic to report}

\item{column}{column name of the statistic to report}

\item{outcome}{string indicating the outcome to select from. If \code{NULL}, the
first outcome is used.}

\item{level}{if estimates are stratified, level of the stratum to report}
}
\description{
\itemize{
\item \code{add_p()} Add column with p-value comparing incidence across stratum
\item \code{add_n()} Add column with the total N, or N within stratum
\item \code{add_nevent()} Add column with the total number of events, or number of events within stratum
\item \code{inline_text()} Report statistics from a \code{tbl_cuminc()} table inline
}
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{add_cuminc_ex1.png}{options: width=50\%}}

\if{html}{Example 2}

\if{html}{\figure{add_cuminc_ex2.png}{options: width=60\%}}
}

\section{p-values}{


The p-values reported in \code{cuminc()}, \code{glance.tidycuminc()} and \code{add_p.tbl_cuminc()}
are Gray's test as described in
Gray RJ (1988) \emph{A class of K-sample tests for comparing the cumulative incidence of a competing risk}, Annals of Statistics, 16:1141-1154.
}

\examples{
# Example 1 ----------------------------------
add_cuminc_ex1 <-
  cuminc(Surv(ttdeath, death_cr) ~ 1, trial) \%>\%
  tbl_cuminc(times = c(12, 24), label_header = "**Month {time}**") \%>\%
  add_nevent() \%>\%
  add_n()

# Example 2 ----------------------------------
add_cuminc_ex2 <-
  cuminc(Surv(ttdeath, death_cr) ~ trt, trial) \%>\%
  tbl_cuminc(times = c(12, 24),
             outcomes = c("death from cancer", "death other causes"),
             label_header = "**Month {time}**") \%>\%
  add_p() \%>\%
  add_nevent(location = c("label", "level")) \%>\%
  add_n(location = c("label", "level"))

# inline_text() ------------------------------
inline_text(add_cuminc_ex2, time = 12, level = "Drug A")
inline_text(add_cuminc_ex2, column = p.value)

}
\seealso{
Other tbl_cuminc tools: 
\code{\link{tbl_cuminc}()}
}
\concept{tbl_cuminc tools}
