% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_clust.R
\name{hier_clust}
\alias{hier_clust}
\title{Hierarchical (Agglomerative) Clustering}
\usage{
hier_clust(
  mode = "partition",
  engine = "stats",
  num_clusters = NULL,
  cut_height = NULL,
  linkage_method = "complete"
)
}
\arguments{
\item{mode}{A single character string for the type of model. The only
possible value for this model is "partition".}

\item{engine}{A single character string specifying what computational engine
to use for fitting. Possible engines are listed below. The default for this
model is \code{"stats"}.}

\item{num_clusters}{Positive integer, number of clusters in model (optional).}

\item{cut_height}{Positive double, height at which to cut dendrogram to
obtain cluster assignments (only used if \code{num_clusters} is \code{NULL})}

\item{linkage_method}{the agglomeration method to be used. This should be (an
unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"}, \code{"single"},
\code{"complete"}, \code{"average"} (= UPGMA), \code{"mcquitty"} (= WPGMA), \code{"median"} (=
WPGMC) or \code{"centroid"} (= UPGMC).}
}
\value{
A \code{hier_clust} cluster specification.
}
\description{
\code{hier_clust()} defines a model that fits clusters based on a distance-based
dendrogram

There are different ways to fit this model, and the method of estimation is
chosen by setting the model engine. The engine-specific pages for this model
are listed below.
\itemize{
\item \link[=details_hier_clust_stats]{stats}
}
}
\details{
\subsection{What does it mean to predict?}{

To predict the cluster assignment for a new observation, we find the closest
cluster. How we measure “closeness” is dependent on the specified type of
linkage in the model:
\itemize{
\item \emph{single linkage}: The new observation is assigned to the same cluster as
its nearest observation from the training data.
\item \emph{complete linkage}: The new observation is assigned to the cluster with the
smallest maximum distances between training observations and the new
observation.
\item \emph{average linkage}: The new observation is assigned to the cluster with the
smallest average distances between training observations and the new
observation.
\item \emph{centroid method}: The new observation is assigned to the cluster with the
closest centroid, as in prediction for k_means.
\item \emph{Ward’s method}: The new observation is assigned to the cluster with the
smallest increase in \strong{error sum of squares (ESS)} due to the new
addition. The ESS is computed as the sum of squared distances between
observations in a cluster, and the centroid of the cluster.
}
}
}
\examples{
# Show all engines
modelenv::get_from_env("hier_clust")

hier_clust()
}
