% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_rvars.R
\name{nest_rvars}
\alias{nest_rvars}
\alias{unnest_rvars}
\title{Nest and unnest \code{rvar} columns in data frames}
\usage{
nest_rvars(data)

unnest_rvars(data)
}
\arguments{
\item{data}{A data frame to nest or unnest.
\itemize{
\item For \code{nest_rvars()}, the data frame should be in long-data-frame-of-draws
format; i.e. it should contain a \code{.draw} column (and optionally \code{.chain}
and \code{.iteration} columns) indexing draws. It should be a grouped by any
columns that are not intended to be nested.
\item For \code{unnest_rvars()}, the data frame should have at least one column that
is an \code{\link{rvar}}; all \code{rvar} columns will be unnested.
}}
}
\value{
For \code{nest_rvars()}, returns a data frame without \code{.chain}, \code{.iteration}, and
\code{.draw} columns, where all non-grouped columns have been converted to \code{\link{rvar}}s.

For \code{unnest_rvars()}, returns a data frame with \code{.chain}, \code{.iteration}, and
\code{.draw} columns added, where every \code{\link{rvar}} column in the input has been
converted to (one or more) columns containing draws from those \code{\link{rvar}}s
in long format. The result is grouped by all non-\code{\link{rvar}} columns in the
input; this ensures that \code{nest_rvars(unnest_rvars(x))} returns \code{x}.
}
\description{
Converts between data-frame-of-\code{rvar}s format and long-data-frame-of-draws
formats by nesting or unnesting all columns containing \code{\link[posterior:rvar]{posterior::rvar}}
objects.
}
\examples{

library(dplyr)

data(RankCorr, package = "ggdist")

# here's a data frame with some rvars
rvar_df = RankCorr \%>\%
  spread_rvars(b[i,], tau[i])
rvar_df

# we can unnest it into long format.
# note how the result is grouped by all non-rvar input columns,
# and nested indices in `b` are converted into columns.
draws_df = rvar_df \%>\%
  unnest_rvars()
draws_df

# calling nest_rvars() again on the result of unnest_rvars()
# recovers the original data frame
nest_rvars(draws_df)

}
