% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture-pseudo_class.R
\name{append_class_draws}
\alias{append_class_draws}
\title{Append Pseudo-class Draws}
\usage{
append_class_draws(x, data = NULL, m = 20)
}
\arguments{
\item{x}{An object for which a method exists, usually a \code{mx_mixture} model.}

\item{data}{A data.frame which the \code{class} variable is appended to. Note
that the row order must be identical to that of the data used to fit \code{x},
as these data will be augmented with a pseudo-class draw for that specific
individual.}

\item{m}{Integer. Number of datasets to generate. Default is 10.}
}
\value{
A data.frame of class \code{class_draws}.
}
\description{
Generates \code{m} datasets with random draws of a variable named \code{class}, with
probability for these draws based on each case's probability of belonging to
that class according to the model in \code{x}.
}
\examples{
if(requireNamespace("OpenMx", quietly = TRUE)){
dat <- iris[c(1:5, 50:55, 100:105),1:3]
colnames(dat) <- letters[1:3]
fit <- mx_profiles(data = dat, classes = 2)

append_class_draws(fit, data = iris[c(1:5, 50:55, 100:105), 4, drop = FALSE])
}
}
