% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_instruments.R
\name{import_instruments}
\alias{import_instruments}
\title{Import all instruments into individual R tables}
\usage{
import_instruments(
  url,
  token,
  drop_blank = TRUE,
  record_id = "record_id",
  envir = .GlobalEnv
)
}
\arguments{
\item{url}{The API URL for your the instance of REDCap}

\item{token}{The API security token}

\item{drop_blank}{Drop records that have no data. TRUE by default.}

\item{record_id}{Name of \code{record_id} variable (if it was changed in REDCap).}

\item{envir}{The name of the environment where the tables should be saved.}
}
\value{
datasets, by default in the global environment
}
\description{
This function takes the url and key for a REDCap
project and returns a table for each instrument/form in the project.
}
\examples{
\dontrun{
import_instruments(
  "https://redcap.miami.edu/api/",
  Sys.getenv("test_API_key")
)
}
}
