% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-regression-fast.R
\name{fast_regression}
\alias{fast_regression}
\title{Generate Model Specification calls to \code{parsnip}}
\usage{
fast_regression(
  .data,
  .rec_obj,
  .parsnip_fns = "all",
  .parsnip_eng = "all",
  .split_type = "initial_split",
  .split_args = NULL
)
}
\arguments{
\item{.data}{The data being passed to the function for the regression problem}

\item{.rec_obj}{The recipe object being passed.}

\item{.parsnip_fns}{The default is 'all' which will create all possible
regression model specifications supported.}

\item{.parsnip_eng}{the default is 'all' which will create all possible
regression model specifications supported.}

\item{.split_type}{The default is 'initial_split', you can pass any type of
split supported by \code{rsample}}

\item{.split_args}{The default is NULL, when NULL then the default parameters
of the split type will be executed for the rsample split type.}
}
\value{
A list or a tibble.
}
\description{
Creates a list/tibble of parsnip model specifications.
}
\details{
With this function you can generate a tibble output of any regression
model specification and it's fitted \code{workflow} object.
}
\examples{
library(recipes, quietly = TRUE)
library(dplyr, quietly = TRUE)

rec_obj <- recipe(mpg ~ ., data = mtcars)
frt_tbl <- fast_regression(mtcars, rec_obj, .parsnip_eng = c("lm","glm"),
.parsnip_fns = "linear_reg")
glimpse(frt_tbl)

}
\seealso{
Other Model_Generator: 
\code{\link{create_model_spec}()},
\code{\link{fast_classification}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Model_Generator}
