% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe.R
\name{add_row}
\alias{add_row}
\title{Add a row to a data frame}
\usage{
add_row(.data, ...)
}
\arguments{
\item{.data}{Data frame to append to.}

\item{...}{Name-value pairs. If you don't supply the name of a variable,
it'll be given the value \code{NA}.}
}
\description{
This is a convenient way to add a single row of data to an existing data
frame. See \code{\link{frame_data}} for an easy way to create an complete
data frame row-by-row.
}
\examples{
# add_row ---------------------------------
df <- data_frame(x = 1:3, y = 3:1)

add_row(df, x = 4, y = 0)

# You can supply vectors, to add multiple rows (this isn't
# recommended because it's a bit hard to read)
add_row(df, x = 4:5, y = 0:-1)

# Absent variables get missing values
add_row(df, x = 4)

# You can't create new variables
\dontrun{
add_row(df, z = 10)
}
}

