% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/picrust.R
\name{picrust}
\alias{picrust}
\title{Predict OTU functional content via PICRUSt}
\usage{
picrust(otu_table, rows_are_taxa, reference = c("gg_ko", "gg_cog"),
  reference_path, cn_normalize = FALSE, sample_normalize = FALSE,
  drop = TRUE)
}
\arguments{
\item{otu_table}{(required) Matrix or dataframe containing taxa abundances
(counts, non-negative integers) across samples. Rows and columns must be
uniquely named.}

\item{rows_are_taxa}{(required) Logical flag indicating whether otu_table
rows correspond to taxa (TRUE) or samples (FALSE).}

\item{reference}{A string for either gg_ko or gg_cog. Defaults to gg_ko.}

\item{reference_path}{Folder path of the reference file}

\item{cn_normalize}{Logical flag for performing 16S rRNA copy number
normalization. Defaults to FALSE.}

\item{sample_normalize}{Logical flag to normalize functional
predictions by the total functional abundance in a sample. Defaults to FALSE.}

\item{drop}{Logical flag to drop empty gene columns. Defaults to TRUE.}
}
\value{
A list containing
\describe{
\item{fxn_table}{A matrix of gene counts across topics.}
\item{fxn_meta}{A list of functional metadata corresponding to fxn_table.}
\item{method_meta}{A matrix of method specific metadata (NSTI).}
}
}
\description{
Given an OTU abundance table prepared with the GreenGenes reference database,
this function predicts the functional content using either COG or KO
precalculated mapping tables that map the taxonomic abundance for a given OTU
to functional abundance content across a set of functional genes.
}
\examples{
\dontrun{
download_ref(destination='/references',reference='gg_ko')

predicted_functions <- picrust(otu_table=GEVERS$OTU,rows_are_taxa=TRUE,
                               reference='gg_ko',reference_path='/references',
                               cn_normalize=TRUE,
                               sample_normalize=FALSE,drop=TRUE)
                           }

}
\references{
Langille, M. G.I.*, Zaneveld, J.*, Caporaso, J. G., McDonald, D., Knights, D.,
a Reyes, J., Clemente, J. C., Burkepile, D. E., Vega Thurber, R. L., Knight, R.,
Beiko, R. G., and Huttenhower, C. (2013). Nature Biotechnology, 1-10. 8.
}
\seealso{
\code{\link{download_ref}} \code{\link{picrust}}
}
