% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.feature_calculations}
\alias{plot.feature_calculations}
\title{Produce a plot for a feature_calculations object}
\usage{
\method{plot}{feature_calculations}(
  x,
  type = c("matrix", "cor", "violin", "box", "quality"),
  norm_method = c("zScore", "Sigmoid", "RobustSigmoid", "MinMax", "MaxAbs"),
  unit_int = FALSE,
  clust_method = c("average", "ward.D", "ward.D2", "single", "complete", "mcquitty",
    "median", "centroid"),
  cor_method = c("pearson", "spearman"),
  feature_names = NULL,
  ...
)
}
\arguments{
\item{x}{\code{feature_calculations} object containing the raw feature matrix produced by \code{theft::calculate_features}}

\item{type}{\code{character} specifying the type of plot to draw. Can be one of \code{"matrix"}, \code{"cor"}, \code{"violin"}, \code{"box"}, or \code{"quality"}. Defaults to \code{"matrix"}}

\item{norm_method}{\code{character} specifying a rescaling/normalising method to apply if \code{type = "matrix"} or if \code{type = "cor"}. Can be one of \code{"zScore"}, \code{"Sigmoid"}, \code{"RobustSigmoid"}, \code{"MinMax"}, or \code{"MaxAbs"}. Defaults to \code{"zScore"}}

\item{unit_int}{\code{Boolean} whether to rescale into unit interval \code{[0,1]} after applying normalisation method. Defaults to \code{FALSE}}

\item{clust_method}{\code{character} specifying the hierarchical clustering method to use if \code{type = "matrix"} or if \code{type = "cor"}. Defaults to \code{"average"}}

\item{cor_method}{\code{character} specifying the correlation method to use if \code{type = "cor"}. Defaults to \code{"pearson"}}

\item{feature_names}{\code{character} vector denoting the name of the features to plot if \code{type = "violin"}. Defaults to \code{NULL}}

\item{...}{Arguments to be passed to \code{ggplot2::geom_bar} if \code{type = "quality"}, \code{ggplot2::geom_raster} if \code{type = "matrix"}, \code{ggplot2::geom_raster} if \code{type = "cor"}, or \code{ggplot2::geom_point} if \code{type = "violin"}}
}
\value{
object of class \code{ggplot} that contains the graphic
}
\description{
Produce a plot for a feature_calculations object
}
\author{
Trent Henderson
}
