% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_semi_local_linear_trend_state_space_model}
\alias{sts_semi_local_linear_trend_state_space_model}
\title{State space model for a semi-local linear trend.}
\usage{
sts_semi_local_linear_trend_state_space_model(num_timesteps, level_scale,
  slope_mean, slope_scale, autoregressive_coef, initial_state_prior,
  observation_noise_scale = 0, initial_step = 0,
  validate_args = FALSE, allow_nan_stats = TRUE, name = NULL)
}
\arguments{
\item{num_timesteps}{Scalar \code{integer} \code{tensor} number of timesteps to model
with this distribution.}

\item{level_scale}{Scalar (any additional dimensions are treated as batch
dimensions) \code{float} \code{tensor} indicating the standard deviation of the
level transitions.}

\item{slope_mean}{Scalar (any additional dimensions are treated as batch
dimensions) \code{float} \code{tensor} indicating the expected long-term mean of
the latent slope.}

\item{slope_scale}{Scalar (any additional dimensions are treated as batch
dimensions) \code{float} \code{tensor} indicating the standard deviation of the
slope transitions.}

\item{autoregressive_coef}{Scalar (any additional dimensions are treated as
batch dimensions) \code{float} \code{tensor} defining the AR1 process on the latent slope.}

\item{initial_state_prior}{instance of \code{tfd_multivariate_normal}
representing the prior distribution on latent states.  Must have
event shape \code{[1]} (as \code{tfd_linear_gaussian_state_space_model} requires a
rank-1 event shape).}

\item{observation_noise_scale}{Scalar (any additional dimensions are
treated as batch dimensions) \code{float} \code{tensor} indicating the standard
deviation of the observation noise.}

\item{initial_step}{Optional scalar \code{integer} \code{tensor} specifying the starting
timestep. Default value: 0.}

\item{validate_args}{\code{logical}. Whether to validate input
with asserts. If \code{validate_args} is \code{FALSE}, and the inputs are
invalid, correct behavior is not guaranteed. Default value: \code{FALSE}.}

\item{allow_nan_stats}{\code{logical}. If \code{FALSE}, raise an
exception if a statistic (e.g. mean/mode/etc...) is undefined for any
batch member. If \code{TRUE}, batch members with valid parameters leading to
undefined statistics will return NaN for this statistic. Default value: \code{TRUE}.}

\item{name}{string` prefixed to ops created by this class.
Default value: "SemiLocalLinearTrendStateSpaceModel".}
}
\value{
an instance of \code{LinearGaussianStateSpaceModel}.
}
\description{
A state space model (SSM) posits a set of latent (unobserved) variables that
evolve over time with dynamics specified by a probabilistic transition model
\code{p(z[t+1] | z[t])}. At each timestep, we observe a value sampled from an
observation model conditioned on the current state, \code{p(x[t] | z[t])}. The
special case where both the transition and observation models are Gaussians
with mean specified as a linear function of the inputs, is known as a linear
Gaussian state space model and supports tractable exact probabilistic
calculations; see \code{tfd_linear_gaussian_state_space_model} for details.
}
\details{
The semi-local linear trend model is a special case of a linear Gaussian
SSM, in which the latent state posits a \code{level} and \code{slope}. The \code{level}
evolves via a Gaussian random walk centered at the current \code{slope}, while
the \code{slope} follows a first-order autoregressive (AR1) process with
mean \code{slope_mean}:\preformatted{level[t] = level[t-1] + slope[t-1] + Normal(0, level_scale)
slope[t] = (slope_mean + autoregressive_coef * (slope[t-1] - slope_mean) +
           Normal(0., slope_scale))
}

The latent state is the two-dimensional tuple \code{[level, slope]}. The
\code{level} is observed at each timestep.
The parameters \code{level_scale}, \code{slope_mean}, \code{slope_scale},
\code{autoregressive_coef}, and \code{observation_noise_scale} are each (a batch of)
scalars. The batch shape of this \code{Distribution} is the broadcast batch shape
of these parameters and of the \code{initial_state_prior}.

Mathematical Details

The semi-local linear trend model implements a
\code{tfp.distributions.LinearGaussianStateSpaceModel} with \code{latent_size = 2}
and \code{observation_size = 1}, following the transition model:\preformatted{transition_matrix = [[1., 1.]
                     [0., autoregressive_coef]]
transition_noise ~ N(loc=slope_mean - autoregressive_coef * slope_mean,
                     scale=diag([level_scale, slope_scale]))
}

which implements the evolution of \code{[level, slope]} described above, and
the observation model:\preformatted{observation_matrix = [[1., 0.]]
observation_noise ~ N(loc=0, scale=observation_noise_scale)
}

which picks out the first latent component, i.e., the \code{level}, as the
observation at each timestep.
}
\seealso{
Other sts: \code{\link{sts_additive_state_space_model}},
  \code{\link{sts_autoregressive_state_space_model}},
  \code{\link{sts_autoregressive}},
  \code{\link{sts_constrained_seasonal_state_space_model}},
  \code{\link{sts_dynamic_linear_regression_state_space_model}},
  \code{\link{sts_dynamic_linear_regression}},
  \code{\link{sts_linear_regression}},
  \code{\link{sts_local_level_state_space_model}},
  \code{\link{sts_local_level}},
  \code{\link{sts_local_linear_trend_state_space_model}},
  \code{\link{sts_local_linear_trend}},
  \code{\link{sts_seasonal_state_space_model}},
  \code{\link{sts_seasonal}},
  \code{\link{sts_semi_local_linear_trend}},
  \code{\link{sts_smooth_seasonal_state_space_model}},
  \code{\link{sts_smooth_seasonal}},
  \code{\link{sts_sparse_linear_regression}},
  \code{\link{sts_sum}}
}
\concept{sts}
