% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts-functions.R
\name{sts_forecast}
\alias{sts_forecast}
\title{Construct predictive distribution over future observations}
\usage{
sts_forecast(observed_time_series, model, parameter_samples,
  num_steps_forecast)
}
\arguments{
\item{observed_time_series}{\code{float} \code{tensor} of shape
\code{concat([sample_shape, model.batch_shape, [num_timesteps, 1]])} where
\code{sample_shape} corresponds to i.i.d. observations, and the trailing \code{[1]}
dimension may (optionally) be omitted if \code{num_timesteps > 1}. May
optionally be an instance of \code{sts_masked_time_series}, which includes
a mask \code{tensor} to specify timesteps with missing observations.}

\item{model}{An instance of \code{StructuralTimeSeries} representing a
time-series model. This represents a joint distribution over
time-series and their parameters with batch shape \code{[b1, ..., bN]}.}

\item{parameter_samples}{\code{list} of \code{tensors} representing posterior samples
of model parameters, with shapes
\code{list(tf$concat(list(list(num_posterior_draws), param<1>$prior$batch_shape, param<1>$prior$event_shape), list(list(num_posterior_draws), param<2>$prior$batch_shape, param<2>$prior$event_shape), ... ) )}
for all model parameters.
This may optionally also be a named list mapping parameter names to \code{tensor} values.}

\item{num_steps_forecast}{scalar \code{integer} \code{tensor} number of steps to forecast}
}
\value{
forecast_dist a \code{tfd_mixture_same_family} instance with event shape
\code{list(num_steps_forecast, 1)} and batch shape \code{tf$concat(list(sample_shape, model$batch_shape))}, with
\code{num_posterior_draws} mixture components.
}
\description{
Given samples from the posterior over parameters, return the predictive
distribution over future observations for num_steps_forecast timesteps.
}
\examples{
\donttest{
observed_time_series <-
  rep(c(3.5, 4.1, 4.5, 3.9, 2.4, 2.1, 1.2), 5) +
  rep(c(1.1, 1.5, 2.4, 3.1, 4.0), each = 7) \%>\%
  tensorflow::tf$convert_to_tensor(dtype = tensorflow::tf$float64)
day_of_week <- observed_time_series \%>\% sts_seasonal(num_seasons = 7)
local_linear_trend <- observed_time_series \%>\% sts_local_linear_trend()
model <- observed_time_series \%>\%
  sts_sum(components = list(day_of_week, local_linear_trend))
states_and_results <- observed_time_series \%>\%
  sts_fit_with_hmc(
    model,
    num_results = 10,
    num_warmup_steps = 5,
    num_variational_steps = 15)
samples <- states_and_results[[1]]
preds <- observed_time_series \%>\%
  sts_forecast(model,
               parameter_samples = samples,
               num_steps_forecast = 50)
predictions <- preds \%>\% tfd_sample(10)
}

}
\seealso{
Other sts-functions: \code{\link{sts_build_factored_surrogate_posterior}},
  \code{\link{sts_build_factored_variational_loss}},
  \code{\link{sts_decompose_by_component}},
  \code{\link{sts_decompose_forecast_by_component}},
  \code{\link{sts_fit_with_hmc}},
  \code{\link{sts_one_step_predictive}},
  \code{\link{sts_sample_uniform_initial_state}}
}
\concept{sts-functions}
