% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi-functions.R
\name{vi_csiszar_vimco}
\alias{vi_csiszar_vimco}
\title{Use VIMCO to lower the variance of the gradient of csiszar_function(Avg(logu))}
\usage{
vi_csiszar_vimco(
  f,
  p_log_prob,
  q,
  num_draws,
  num_batch_draws = 1,
  seed = NULL,
  name = NULL
)
}
\arguments{
\item{f}{function representing a Csiszar-function in log-space.}

\item{p_log_prob}{function representing the natural-log of the
probability under distribution \code{p}. (In variational inference \code{p} is the
joint distribution.)}

\item{q}{\code{tfd$Distribution}-like instance; must implement: \code{sample(n, seed)}, and
\code{log_prob(x)}. (In variational inference \code{q} is the approximate posterior
distribution.)}

\item{num_draws}{Integer scalar number of draws used to approximate the
f-Divergence expectation.}

\item{num_batch_draws}{Integer scalar number of draws used to approximate the
f-Divergence expectation.}

\item{seed}{\code{integer} seed for \code{q$sample}.}

\item{name}{String prefixed to Ops created by this function.}
}
\value{
vimco The Csiszar f-Divergence generalized VIMCO objective
}
\description{
This function generalizes VIMCO (Mnih and Rezende, 2016) to Csiszar
f-Divergences.
}
\details{
Note: if \code{q.reparameterization_type = tfd.FULLY_REPARAMETERIZED},
consider using \code{monte_carlo_csiszar_f_divergence}.

The VIMCO loss is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{vimco = f(Avg\{logu[i] : i=0,...,m-1\})
where,
logu[i] = log( p(x, h[i]) / q(h[i] | x) )
h[i] iid~ q(H | x)
}\if{html}{\out{</div>}}

Interestingly, the VIMCO gradient is not the naive gradient of \code{vimco}.
Rather, it is characterized by:

\if{html}{\out{<div class="sourceCode">}}\preformatted{grad[vimco] - variance_reducing_term
}\if{html}{\out{</div>}}

where,

\if{html}{\out{<div class="sourceCode">}}\preformatted{variance_reducing_term = Sum\{ grad[log q(h[i] | x)] * (vimco - f(log Avg\{h[j;i] : j=0,...,m-1\})) #' : i=0, ..., m-1 \}
h[j;i] =  u[j]  for j!=i,  GeometricAverage\{ u[k] : k!=i\} for j==i
}\if{html}{\out{</div>}}

(We omitted \code{stop_gradient} for brevity. See implementation for more details.)
The \verb{Avg\{h[j;i] : j\}} term is a kind of "swap-out average" where the \code{i}-th
element has been replaced by the leave-\code{i}-out Geometric-average.

This implementation prefers numerical precision over efficiency, i.e.,
\code{O(num_draws * num_batch_draws * prod(batch_shape) * prod(event_shape))}.
(The constant may be fairly large, perhaps around 12.)
}
\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1602.06725}{Andriy Mnih and Danilo Rezende. Variational Inference for Monte Carlo objectives. In \emph{International Conference on Machine Learning}, 2016.}
}
}

\seealso{
Other vi-functions: 
\code{\link{vi_amari_alpha}()},
\code{\link{vi_arithmetic_geometric}()},
\code{\link{vi_chi_square}()},
\code{\link{vi_dual_csiszar_function}()},
\code{\link{vi_fit_surrogate_posterior}()},
\code{\link{vi_jeffreys}()},
\code{\link{vi_jensen_shannon}()},
\code{\link{vi_kl_forward}()},
\code{\link{vi_kl_reverse}()},
\code{\link{vi_log1p_abs}()},
\code{\link{vi_modified_gan}()},
\code{\link{vi_monte_carlo_variational_loss}()},
\code{\link{vi_pearson}()},
\code{\link{vi_squared_hellinger}()},
\code{\link{vi_symmetrized_csiszar_function}()}
}
\concept{vi-functions}
